<?php
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class VisualizzatoreProdottiDalNegozio extends VisualizzatoreComponente {
        private $gestoreTraduzioni;
        private $linguaCorrente;
        private $prodottiDaEvitare;
        private $impostazioni;
        private $impostazioniEcommerce;
        private $datiVisualizzatore;
        
        function __construct($db) {
            parent::__construct($db);
            $this->prodottiDaEvitare = array();
            $this->impostazioniEcommerce = parent::getDb()->leggiSingolaRiga("geecEc_impostazioni",1);
            $this->impostazioni          = parent::getDb()->leggiSingolaRiga("geecB_impostazioni",1);
        }
        
        function generaContenutoSezione($dati) {
            
            if(isset($_SESSION["geecomUser_idGruppo"]) && $_SESSION["geecomUser_idGruppo"]!=0) {
                $datiGruppo = parent::getDb()->leggiSingolaRiga("geecAd_gruppi",$_SESSION["geecomUser_idGruppo"]);
            }
            else {
                $datiGruppo = null;
            }
            
            if(parent::getDb()->contaRigheTabella("geecEc_prodotti",array("pubblicato"=>"si"))==0){
		parent::messaggioDiErrore("Attenzione, non ci sono prodotti pubblicati. Creane uno in componenti -> ecommerce -> proodtti");
	    }
            else {
                $riga = parent::getDb()->leggiSingolaRiga("geecEc_righeProdotti",$dati["idElemento"]);
                $this->datiVisualizzatore = $riga;
                
                $stampaPulsante = ($this->impostazioniEcommerce["bloccaAcquisti"]=="si") ? false : true;
                $mostraPrezzo   = ($riga["mostraPrezzo"]=="si") ? true : false;
                ?>
                <div class="<?= $riga['spazioOccupato'] ?>">
                    <div <?= ($riga['tipoVisualizzazione']=="tradizionale") ? "class=\"row prodotti-dal-negozio\"" : "id=\"sliderProdotti1\" class=\"owl-carousel owl-theme\"" ?>>
                    <?php
                        if($riga['mostraTitoloComponente']=="si") {
                            echo"<div class=\"col-12\">
                                <h3 class=\"text-center separatore-inferiore\"> {$riga['nome']} </h3>"
                            ."</div>";
                        }
                        
                        if($riga["categoria"]==-1) { // se è stata selezionata la stampa delle categorie indicate
                            $this->stampaProdottiCategorieIndicate($riga,$datiGruppo,$mostraPrezzo,$stampaPulsante);
                        }
                        else {
                            $this->stampaProdottiClassico($riga,$datiGruppo,$mostraPrezzo,$stampaPulsante);
                        }
                    ?>
                    </div>
                    <?php $this->stampaPulsante($riga) ?>
                </div>
                <?php
            }
        }
        
        function stampaProdottiClassico($riga,$datiGruppo,$mostraPrezzo,$stampaPulsante) {
            $stringaOrdinamento       = $this->generaStringaOrdinamentoQuery($riga["tipoProdotti"]);
            $stringaAggiuntivaRicerca = ($riga["tipoProdotti"]=="offerta") ? "AND prezzoOfferta > 0 ": "";
            $stringaEscludiProdottiEsauriti = ($riga["escludiProdottiEsauriti"]=="si") ? "AND disponibilita > 0 ": "";
            
            if($riga["escludiCategoria"]>0) {
                $stringaEscludiCategorie = "(categoria != {$riga["escludiCategoria"]}";
                
                $arrayIdSottoCategorieEscluse = recuperaIdSottoCategorie(parent::getDb(),"ecommerce",$riga["escludiCategoria"]);
                foreach($arrayIdSottoCategorieEscluse as $idSottoCategoria) {
                    $stringaEscludiCategorie .=" AND categoria!={$idSottoCategoria}";
                }
                $stringaEscludiCategorie .=") ";
            }
            else {
                $stringaEscludiCategorie = "(categoria != {$riga["escludiCategoria"]})";
            }
            
            if($riga["marca"]!="") {
                $stringaMarche = "AND marca LIKE '{$riga["marca"]}' ";
            }
            else {
                $stringaMarche = "";
            }
            
            // se è stata selezionata una marca da escludere viene aggiunta alla stringa delle marche 
            if($riga["escludiMarca"]!="") {
                $stringaMarche .= "AND escludiMarca NOT LIKE '{$riga["escludiMarca"]}' ";
            }
            
            $arrayIdSottoCategorie = recuperaIdSottoCategorie(parent::getDb(),"ecommerce",$riga["categoria"]);
            if($riga["categoria"]!=0) {
                $arrayIdSottoCategorie = recuperaIdSottoCategorie(parent::getDb(),"ecommerce",$riga["categoria"]);
                
                $querySottoCategoria = "SELECT * FROM geec_categorie WHERE tipo LIKE 'ecommerce' AND categoriaMadre='{$riga["categoria"]}'";
                $risSottoCategoria   = parent::getDb()->eseguiQueryLettura($querySottoCategoria);

                $stringaCategorie = "AND (categoria='{$riga["categoria"]}' ";
                foreach($arrayIdSottoCategorie as $idSottoCategoria) {
                    $stringaCategorie .=" OR categoria={$idSottoCategoria}";
                }
                
                $queryProdotti = "SELECT * FROM geecEc_prodotti 
                    WHERE $stringaEscludiCategorie $stringaCategorie $stringaMarche )
                    AND pubblicato LIKE 'si' $stringaEscludiProdottiEsauriti
                    AND lingua LIKE '%{$riga["lingua"]}%' 
                    $stringaAggiuntivaRicerca
                    $stringaOrdinamento 
                    LIMIT {$riga["numeroProdotti"]}";
            }
            else {
                $queryProdotti = "SELECT * FROM geecEc_prodotti WHERE pubblicato LIKE 'si' AND $stringaEscludiCategorie AND lingua LIKE '%{$riga["lingua"]}%' $stringaMarche $stringaAggiuntivaRicerca $stringaOrdinamento LIMIT {$riga["numeroProdotti"]}";
            }
            
            $risProdotti = $this->getDb()->eseguiQueryLettura($queryProdotti);
            while($prodotto = $risProdotti->fetch_assoc()) {
                $linkProdotto = GeneratoreUrl::creaUrlProdotto($prodotto, $this->impostazioni["ottimizzazioneUrl"],$this->impostazioni["urlSito"]);
                                
                if($prodotto["categoria"]>0) {
                    $categoriaProdotto = parent::getDb()->leggiSingolaRiga("geec_categorie",$prodotto["categoria"]);
                    $linkCategoria     = GeneratoreUrl::creaUrlCategoria($categoriaProdotto, $this->impostazioni["ottimizzazioneUrl"],$this->impostazioni["urlSito"]);
                }
                else {
                    $categoriaProdotto["nome"] = "";
                    $linkCategoria = "";
                }
                
                $classeDivDimensioniProdotto = ($riga['tipoVisualizzazione']=="tradizionale") ? $riga["dimensioneDivSingoloProdotto"] : "elementoSliderProdotti";
                if($riga["aspetto"]=="altezzaControllata") {
                    StampaContenuti::stampaProdottoImgBackground($this->gestoreTraduzioni,$this->impostazioniEcommerce,$prodotto,$linkProdotto,$categoriaProdotto,$linkCategoria,$classeDivDimensioniProdotto,$datiGruppo,$mostraPrezzo,$stampaPulsante);
                }
                else { // immagini libere
                    StampaContenuti::stampaProdottoSenzaImgBackground($this->gestoreTraduzioni,$this->impostazioniEcommerce,$prodotto,$linkProdotto,$categoriaProdotto,$linkCategoria,$classeDivDimensioniProdotto,$datiGruppo,$mostraPrezzo,$stampaPulsante);
                }
            }
        }

        /*
         * questo metodo viene usato se $riga["categoria"] == -1, ovvero l'utente ha scelto
         * di creare il 
         */
        function stampaProdottiCategorieIndicate($riga,$datiGruppo,$stampaPulsante) {
            $stringaOrdinamento = $this->generaStringaOrdinamentoQuery($riga["tipoProdotti"]);
            
            if($riga["categorieIndicate"]=="") {
                parent::messaggioDiErrore("Nessuna categoria selezionata");
            }
            else {
                $categorieIndicate = explode(",",$riga["categorieIndicate"]);
                foreach($categorieIndicate as $categoria) {

                    $queryArticoli = "SELECT * FROM geecEc_prodotti 
                        WHERE (categoria=$categoria AND categoria != {$riga["escludiCategoria"]}) OR categoria IN (SELECT id FROM geec_categorie WHERE categoriaMadre=$categoria AND categoria != {$riga["escludiCategoria"]} )
                        AND pubblicato LIKE 'si' 
                        AND lingua LIKE '%{$riga["lingua"]}%' 
                        $stringaOrdinamento DESC LIMIT 1";

                    $risArticoli = parent::getDb()->eseguiQueryLettura($queryArticoli);
                    $prodotto = $risArticoli->fetch_assoc();

                    $arrayCategorie = array();
                    if($prodotto["categoria"]>0) {
                        $datiCategoriaPrincipale = parent::getDb()->leggiSingolaRiga("geec_categorie",$prodotto["categoria"]);
                        $arrayCategorie[$datiCategoriaPrincipale["nome"]] = GeneratoreUrl::creaUrlCategoria($datiCategoriaPrincipale, $this->impostazioni["ottimizzazioneUrl"],$this->impostazioni["urlSito"]);
                    }
                    $queryCategorieArticoli="SELECT c.* FROM geec_associazioneCategorieContenuti AS ac JOIN geec_categorie AS c "
                                    . "ON ac.idCategoria = c.id "
                                    . "WHERE ac.idContenuto = {$prodotto["id"]}";
                    $risCategorie = $this->getDb()->eseguiQueryLettura($queryCategorieArticoli);
                    while($categoria = $risCategorie->fetch_assoc()) {
                        $arrayCategorie[$categoria["nome"]] = GeneratoreUrl::creaUrlCategoria($categoria, $this->impostazioni["ottimizzazioneUrl"],$this->impostazioni["urlSito"]);
                    }

                    $linkCategoria = ($prodotto["categoria"]>0) ? GeneratoreUrl::creaUrlCategoria($datiCategoriaPrincipale,$this->impostazioni["ottimizzazioneUrl"],$this->impostazioni["urlSito"]) : "";

                    $classeDivDimensioniProdotto = ($riga['tipoVisualizzazione']=="tradizionale") ? $riga["dimensioneDivSingoloProdotto"] : "";
                    if($riga["aspetto"]=="altezzaControllata") {
                        StampaContenuti::stampaProdottoImgBackground($prodotto,$this->impostazioniEcommerce,$datiCategoriaPrincipale,$linkCategoria,$classeDivDimensioniProdotto,$datiGruppo,$stampaPulsante);
                    }
                    else { // immagini libere
                        StampaContenuti::stampaProdottoSenzaImgBackground($prodotto,$this->impostazioniEcommerce,$datiCategoriaPrincipale,$linkCategoria,$classeDivDimensioniProdotto,$datiGruppo,$stampaPulsante);
                    }
                }
            }
        }
        
        function stampaPulsante($datiVisualizzatore) {
            if($datiVisualizzatore["etichettaPulsanteAltriProdotti"]!="") {
                echo"<div class=\"text-center mx-auto\">
                        <a href=\"{$datiVisualizzatore["linkPulsanteAltriProdotti"]}\" class=\"btn btn-primary sharp leggi-tutto\">{$datiVisualizzatore["etichettaPulsanteAltriProdotti"]}</a>
                    </div>";
            }
        }
        
        /*
         * QUesto metodo genera
         */
        function generaStringaOrdinamentoQuery($tipoProdotti) {
            switch($tipoProdotti) {
                case "alfabetico-AZ":
                    return "ORDER BY nome ASC";
                case "alfabetico-ZA":
                    return "ORDER BY nome DESC";
                case "casuali":
                    return "ORDER BY RAND()";
                case "offerta":
                    return "ORDER BY RAND()";
                default:
                    return "";
            }
        }
        
        // getter & setter
        function getJavascriptAssociato() {
            if($this->datiVisualizzatore["dimensioneDivSingoloProdotto"] == "col-md-6 col-lg-3") {
                $prodottiARisoluzioneDesktop = 4;
            }
            else if($this->datiVisualizzatore["dimensioneDivSingoloProdotto"] = "col-md-4") {
                $prodottiARisoluzioneDesktop = 4;
            }
            else if($this->datiVisualizzatore["dimensioneDivSingoloProdotto"] = "col-md-6") {
                $prodottiARisoluzioneDesktop = 2;
            }
            else {
                $prodottiARisoluzioneDesktop = 1;
            }
            
            return "<script type=\"text/javascript\">
                        $('#sliderProdotti1').owlCarousel({
                        loop:false,
                        margin:10,
                        nav:false,
                        responsive:{
                          0:{
                            items:1
                          },
                          600:{
                            items:2
                          },
                          1000:{
                            items:$prodottiARisoluzioneDesktop
                          }
                        }
                      })
                </script>";
        }
        
        public function getGestoreTraduzioni() {
            return $this->gestoreTraduzioni;
        }

        public function getLinguaCorrente() {
            return $this->linguaCorrente;
        }

        public function setGestoreTraduzioni($gestoreTraduzioni): void {
            $this->gestoreTraduzioni = $gestoreTraduzioni;
        }

        public function setLinguaCorrente($linguaCorrente): void {
            $this->linguaCorrente = $linguaCorrente;
        }
    }
